#ifndef _TerminalLogger_h__
#define _TerminalLogger_h__

#include <GSTenums.h>
#include <Utils/ILogger.h>
#include <buildspec.h>

namespace GST
{
namespace Utils
{

class GST_API_EXPORT TerminalLogger : public ILogger
{
public:
	TerminalLogger();

	virtual void printError(const std::string &msg);
	virtual void printWarning(const std::string &msg);
	virtual void printStatus(const std::string &msg);
	virtual void printDebug(const std::string &msg);
	virtual void printNetworkPID(const long &pid, const std::string &sql);

	Utils::LogLevel getLogFilter() const;
	void setLogFilter(Utils::LogLevel val);

protected:
	Utils::LogLevel m_logFilter;
};

} // namespace Utils
} // namespace GST

#endif // _TerminalLogger_h__
